#version 330
#extension GL_EXT_gpu_shader4 : enable
// mandala pattern 1Mod01.fsh  by  ankd

//https://www.shadertoy.com/view/WlfGWS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define WHITE vec3(1.0)
#define BLACK vec3(0.0)
#define RED vec3(1.0, 0.,0.)
#define BLUE vec3(0.,0.,1.)
#define YELLOW vec3(1.,1.,0.)
#define HANADA vec3(39., 146., 195.)/255.0

const float PI = 3.14159265359;

float rand(in vec2 n){
    return fract(sin(dot(n, vec2(12.9898, 78.233)))*43758.5453);
}
float rand(in float n){
    return rand(vec2(n));
}
float noise(in float x){
    float f = fract(x);
    float i = floor(x);
    //return mix(rand(i), rand(i+1.0), f);
    return mix(rand(i), rand(i+1.0), f*f*(3.0-2.0*f));
    //return mix(rand(i), rand(i+1.0), smoothstep(0., 1., f));
}
float noise(in vec2 st){
    vec2 f = fract(st);
    vec2 i = floor(st);
    
    float a = rand(i);
    float b = rand(i + vec2(1.,0.));
    float c = rand(i + vec2(0.,1.));
    float d = rand(i + vec2(1.,1.));
    
    vec2 u = f*f*(3.0-2.0*f);

    return mix(a,b,u.x)+
        		(c-a)*u.y*(1.0-u.x) +
        		(d-b)*u.x*u.y;
}

mat2 rotate(in float r){
    float c=cos(r), s=sin(r);
    return mat2(c, -s, s, c);
}
float usin(in float x){
    return 0.5+0.5*sin(x);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
	uv = (gl_FragCoord.xy*2.0 - iResolution.xy)/min(iResolution.x, iResolution.y);

    float t = 0.2*iTime;
    for(int i=0;i<5;i++){
        float a = atan(uv.x, uv.y);
        float b = floor(5.0+4.*fract(iTime*0.25));
	    a *= b / (2.0*PI);
        a = abs(fract(a*0.5-b*0.5)*2.0-1.0);
        a *= (2.0*PI)/b;
        uv = length(uv)*vec2(sin(a+t*0.7), cos(a+t*0.8));
        uv -= vec2(0.2+1.8*usin(iTime*0.3), 0.);
        uv = fract(uv)*2.0-1.0;
    }
    
	float v = noise(uv);
    
    vec3 col1 = mix(RED, YELLOW, usin(iTime*0.4));
    vec3 col2 = mix(BLACK, HANADA, usin(iTime*0.9));
    vec3 col = mix(col1, col2, v);
    
    col *= clamp(length(uv), 0., 1.);
    
	uv = (gl_FragCoord.xy*2.0 - iResolution.xy)/min(iResolution.x, iResolution.y);
    col *= exp(-0.8*length(uv));
    col += 1.1*usin(iTime*0.4)*exp(-1.2*length(uv));
    
    gl_FragColor = vec4(col,1.0);
}